<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class PropertyType extends Model 
{

    protected $table = 'property_types';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];

    public function room_types()
    {
        return $this->hasMany('App\Models\RoomType', 'property_type_id');
    }

    public function rules()
    {
        return $this->hasMany('App\Models\PropertiesRule', 'property_type_id');
    }

}